RegisterLocalizedText("SWITCH_CHAR_BLIP","~GRAPPLE~ Switch character")

local gTransitionASAP = false
local gTransition
local gUsingBlip
local gWaiting = false
local gScript

RegisterNetworkEventHandler("models:AllowCommands",function()
	SetCommand("models_reset_delay",CB_ResetDelay,false,"Usage: models_reset_delay [player_id]\nReset the character switch delay for yourself or another player.")
end)
RegisterNetworkEventHandler("models:SetupTransition",function(a,x,y,z,h)
	gTransition = {a,x,y,z,h}
end)
RegisterNetworkEventHandler("models:SetPicker",function(active,info)
	if active then
		if not gScript then
			gScript = StartScript("cl_picker.lua")
			if gScript then
				local env = GetScriptEnvironment(gScript)
				env.gInitialId = info.initial
				env.gFirstPick = info.first
				env.gOwnedChars = info.owned
				env.gUnlockedChars = info.unlocked
				env.gDelaySwitch = info.hours ~= nil
				env.gDelayHours = info.hours
				env.gDelayMinutes = info.minutes
			end
		end
	elseif gScript then
		if gTransition then
			gTransitionASAP = true
		end
		TerminateScript(gScript)
		gScript = nil
	end
end)
RegisterNetworkEventHandler("models:StopWaiting",function()
	gWaiting = false
end)

function main()
	local x,y,z = 528.27,-59.54,5.34
	SendNetworkEvent("models:StartScript")
	while true do
		if gTransitionASAP and not AreaIsLoading() then
			local started
			local a,x,y,z,h = unpack(gTransition)
			CameraFade(0,0)
			PlayerSetPosXYZArea(x,y,z,a)
			AreaDisableCameraControlForTransition(true)
			started = GetAccurateTimer()
			while AreaIsLoading() or IsStreamingBusy() or GetAccurateTimer() - started < 1000 do
				Wait(0)
			end
			PlayerSetHealth(PedGetMaxHealth(gPlayer))
			PedFaceHeading(gPlayer,h,0)
			CameraReturnToPlayer()
			AreaDisableCameraControlForTransition(false)
			CameraFade(1000,1)
			gTransitionASAP = false
			gTransition = nil
		end
		if DistanceBetweenCoords3d(x,y,z,PlayerGetPosXYZ()) < 20 and PlayerIsInAreaXYZ(x,y,z,1,9) and F_NoActivity() and PedMePlaying(gPlayer,"DEFAULT_KEY",true) then
			if not gUsingBlip and IsButtonBeingPressed(9,0) then
				gUsingBlip = GetAccurateTimer()
				PedSetActionNode(gPlayer,"/GLOBAL","")
				PlayerSetControl(0)
				CameraFade(650,0)
			end
			TextPrint("SWITCH_CHAR_BLIP",0.1,3)
		end
		if gUsingBlip and GetAccurateTimer() - gUsingBlip >= 800 then
			gWaiting = true
			PlayerSetControl(1)
			SendNetworkEvent("models:RequestPicker")
			while gWaiting do
				Wait(0)
			end
			if not gScript then
				CameraFade(0,1)
			end
			gUsingBlip = nil
		end
		Wait(0)
	end
end
function MissionCleanup()
	if gTransitionASAP or gUsingBlip then
		AreaDisableCameraControlForTransition(false)
		PlayerSetControl(1)
		CameraFade(0,1)
	end
end

function F_NoActivity()
	if dsl.activity and dsl.activity.IsPlaying() then
		return false
	end
	return true
end
function CB_ResetDelay(id)
	if id then
		id = tonumber(id)
		if id and math.floor(id) == id and id >= 0 then
			SendNetworkEvent("models:ResetDelay",id)
		else
			PrintError("invalid player id")
		end
	else
		SendNetworkEvent("models:ResetDelay")
	end
end
